/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.sitraka;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Random;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.LogStreamHandler;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.FileSet;

public class CovMerge
extends Task {
    private File home = null;
    private File tofile = null;
    private Vector filesets = new Vector();
    private boolean verbose;

    public void setHome(File value) {
        this.home = value;
    }

    public void setTofile(File value) {
        this.tofile = value;
    }

    public void setVerbose(boolean flag) {
        this.verbose = flag;
    }

    public void addFileset(FileSet fs) {
        this.filesets.addElement(fs);
    }

    public void execute() throws BuildException {
        this.checkOptions();
        File paramfile = this.createParamFile();
        try {
            try {
                Commandline cmdl = new Commandline();
                cmdl.setExecutable(new File(this.home, "jpcovmerge").getAbsolutePath());
                if (this.verbose) {
                    cmdl.createArgument().setValue("-v");
                }
                cmdl.createArgument().setValue("-jp_paramfile=" + paramfile.getAbsolutePath());
                LogStreamHandler handler = new LogStreamHandler((Task)this, 2, 1);
                Execute exec = new Execute((ExecuteStreamHandler)handler);
                this.log(cmdl.toString(), 3);
                exec.setCommandline(cmdl.getCommandline());
                int exitValue = exec.execute();
                if (exitValue != 0) {
                    throw new BuildException("JProbe Coverage Merging failed (" + exitValue + ")");
                }
                Object var7_7 = null;
                paramfile.delete();
            }
            catch (IOException e) {
                throw new BuildException("Failed to run JProbe Coverage Merge: " + e);
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            paramfile.delete();
            throw throwable;
        }
    }

    protected void checkOptions() throws BuildException {
        if (this.tofile == null) {
            throw new BuildException("'tofile' attribute must be set.");
        }
        if (this.home == null) {
            throw new BuildException("'home' attribute must be set to JProbe Coverage home directory");
        }
        File jar = new File(this.home, "coverage.jar");
        if (!jar.exists()) {
            throw new BuildException("'home' attribute is not set to Coverage home directory: " + this.home);
        }
    }

    protected File[] getSnapshots() {
        Vector<File> v = new Vector<File>();
        int size = this.filesets.size();
        int i = 0;
        while (i < size) {
            FileSet fs = (FileSet)this.filesets.elementAt(i);
            DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
            ds.scan();
            String[] f = ds.getIncludedFiles();
            int j = 0;
            while (j < f.length) {
                String pathname = f[j];
                File file = new File(ds.getBasedir(), pathname);
                file = ((ProjectComponent)this).project.resolveFile(file.getPath());
                v.addElement(file);
                ++j;
            }
            ++i;
        }
        Object[] files = new File[v.size()];
        v.copyInto(files);
        return files;
    }

    protected File createParamFile() throws BuildException {
        File[] snapshots = this.getSnapshots();
        File file = this.createTmpFile();
        FileWriter fw = null;
        try {
            fw = new FileWriter(file);
            PrintWriter pw = new PrintWriter(fw);
            int i = 0;
            while (i < snapshots.length) {
                pw.println(snapshots[i].getAbsolutePath());
                ++i;
            }
            pw.println(((ProjectComponent)this).project.resolveFile(this.tofile.getPath()));
            pw.flush();
            return file;
        }
        catch (IOException e) {
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (IOException ignored) {
                    // empty catch block
                }
            }
            throw new BuildException("I/O error while writing to " + file, (Throwable)e);
        }
    }

    protected File createTmpFile() {
        long rand = new Random(System.currentTimeMillis()).nextLong();
        File file = new File("jpcovmerge" + rand + ".tmp");
        return file;
    }
}

