/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.FileList;
import org.apache.tools.ant.types.FileSet;

public class DependSet
extends MatchingTask {
    private Vector sourceFileSets = new Vector();
    private Vector sourceFileLists = new Vector();
    private Vector targetFileSets = new Vector();
    private Vector targetFileLists = new Vector();

    public void addSrcfileset(FileSet fileSet) {
        this.sourceFileSets.addElement(fileSet);
    }

    public void addSrcfilelist(FileList fileList) {
        this.sourceFileLists.addElement(fileList);
    }

    public void addTargetfileset(FileSet fileSet) {
        this.targetFileSets.addElement(fileSet);
    }

    public void addTargetfilelist(FileList fileList) {
        this.targetFileLists.addElement(fileList);
    }

    public void execute() throws BuildException {
        Object object;
        Object object2;
        Object object3;
        String[] stringArray;
        Object object4;
        Object object5;
        if (this.sourceFileSets.size() == 0 && this.sourceFileLists.size() == 0) {
            throw new BuildException("At least one <srcfileset> or <srcfilelist> element must be set");
        }
        if (this.targetFileSets.size() == 0 && this.targetFileLists.size() == 0) {
            throw new BuildException("At least one <targetfileset> or <targetfilelist> element must be set");
        }
        long l = new Date().getTime();
        String string = System.getProperty("os.name").toLowerCase();
        if (string.indexOf("windows") >= 0) {
            l += 2000L;
        }
        Vector<Object> vector = new Vector<Object>();
        Enumeration enumeration = this.targetFileSets.elements();
        while (enumeration.hasMoreElements()) {
            FileSet fileSet = (FileSet)enumeration.nextElement();
            object5 = fileSet.getDirectoryScanner(this.project);
            object4 = ((DirectoryScanner)object5).getIncludedFiles();
            int n = 0;
            while (n < ((String[])object4).length) {
                stringArray = new File(fileSet.getDir(this.project), (String)object4[n]);
                vector.addElement(stringArray);
                if (stringArray.lastModified() > l) {
                    this.log("Warning: " + (String)object4[n] + " modified in the future.", 1);
                }
                ++n;
            }
        }
        boolean bl = true;
        object5 = this.targetFileLists.elements();
        while (object5.hasMoreElements()) {
            object4 = (FileList)object5.nextElement();
            String[] stringArray2 = ((FileList)object4).getFiles(this.project);
            int n = 0;
            while (n < stringArray2.length) {
                object3 = new File(((FileList)object4).getDir(this.project), stringArray2[n]);
                if (!((File)object3).exists()) {
                    this.log(stringArray2[n] + " does not exist.", 3);
                    bl = false;
                } else {
                    vector.addElement(object3);
                    if (((File)object3).lastModified() > l) {
                        this.log("Warning: " + stringArray2[n] + " modified in the future.", 1);
                    }
                }
                ++n;
            }
        }
        if (bl) {
            object4 = this.sourceFileSets.elements();
            while (bl && object4.hasMoreElements()) {
                FileSet fileSet = (FileSet)object4.nextElement();
                stringArray = fileSet.getDirectoryScanner(this.project);
                object3 = stringArray.getIncludedFiles();
                int n = 0;
                do {
                    if (((File)(object2 = new File(fileSet.getDir(this.project), (String)object3[n]))).lastModified() > l) {
                        this.log("Warning: " + (String)object3[n] + " modified in the future.", 1);
                    }
                    object = vector.elements();
                    while (bl && object.hasMoreElements()) {
                        File file = (File)object.nextElement();
                        if (((File)object2).lastModified() <= file.lastModified()) continue;
                        this.log(file.getPath() + " is out of date with respect to " + (String)object3[n], 3);
                        bl = false;
                    }
                } while (bl && ++n < ((Object)object3).length);
            }
        }
        if (bl) {
            object4 = this.sourceFileLists.elements();
            block7: while (bl && object4.hasMoreElements()) {
                FileList fileList = (FileList)object4.nextElement();
                stringArray = fileList.getFiles(this.project);
                int n = 0;
                do {
                    File file;
                    if ((file = new File(fileList.getDir(this.project), stringArray[n])).lastModified() > l) {
                        this.log("Warning: " + stringArray[n] + " modified in the future.", 1);
                    }
                    if (!file.exists()) {
                        this.log(stringArray[n] + " does not exist.", 3);
                        bl = false;
                        continue block7;
                    }
                    object2 = vector.elements();
                    while (bl && object2.hasMoreElements()) {
                        object = (File)object2.nextElement();
                        if (file.lastModified() <= ((File)object).lastModified()) continue;
                        this.log(((File)object).getPath() + " is out of date with respect to " + stringArray[n], 3);
                        bl = false;
                    }
                } while (bl && ++n < stringArray.length);
            }
        }
        if (!bl) {
            this.log("Deleting all target files. ", 3);
            object4 = vector.elements();
            while (object4.hasMoreElements()) {
                File file = (File)object4.nextElement();
                this.log("Deleting file " + file.getAbsolutePath(), 3);
                file.delete();
            }
        }
    }
}

