/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.compilers;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.compilers.DefaultCompilerAdapter;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Path;

public class Gcj
extends DefaultCompilerAdapter {
    public boolean execute() throws BuildException {
        this.attributes.log("Using gcj compiler", 3);
        Commandline commandline = this.setupGCJCommand();
        int n = commandline.size();
        this.logAndAddFilesToCompile(commandline);
        return this.executeExternalCompile(commandline.getCommandline(), n) == 0;
    }

    protected Commandline setupGCJCommand() {
        Commandline commandline = new Commandline();
        Path path = new Path(this.project);
        if (this.bootclasspath != null) {
            path.append(this.bootclasspath);
        }
        this.addExtdirsToClasspath(path);
        if (this.bootclasspath == null || this.bootclasspath.size() == 0) {
            this.includeJavaRuntime = true;
        }
        path.append(this.getCompileClasspath());
        path.append(this.src);
        commandline.setExecutable("gcj");
        if (this.destDir != null) {
            commandline.createArgument().setValue("-d");
            commandline.createArgument().setFile(this.destDir);
            if (this.destDir.mkdirs()) {
                throw new BuildException("Can't make output directories. Maybe permission is wrong. ");
            }
        }
        commandline.createArgument().setValue("-classpath");
        commandline.createArgument().setPath(path);
        if (this.encoding != null) {
            this.attributes.log("gcj doesn't support -encoding option.", 1);
        }
        if (this.debug) {
            commandline.createArgument().setValue("-g1");
        }
        if (this.optimize) {
            commandline.createArgument().setValue("-O");
        }
        commandline.createArgument().setValue("-C");
        return commandline;
    }
}

