/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.javasource;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JComment;
import org.exolab.javasource.JDocComment;
import org.exolab.javasource.JDocDescriptor;
import org.exolab.javasource.JMethodSignature;
import org.exolab.javasource.JModifiers;
import org.exolab.javasource.JNaming;
import org.exolab.javasource.JSourceWriter;
import org.exolab.javasource.JType;

public class JInterface
extends JType {
    private static final String DEFAULT_HEADER = "$Id$";
    private static final String version = "$Revision$ $Date$";
    private JComment header = null;
    private Vector imports = null;
    private Vector interfaces = null;
    private JDocComment jdc = null;
    private Vector methods = null;
    private JModifiers modifiers = null;
    private String packageName = null;

    public JInterface(String string) throws IllegalArgumentException {
        super(string);
        if (!JInterface.isValidClassName(string)) {
            String string2 = this.getLocalName();
            String string3 = "'" + string2 + "' is ";
            string3 = JNaming.isKeyword(string2) ? string3 + "a reserved word and may not be used as  a class name." : string3 + "not a valid Java identifier.";
            throw new IllegalArgumentException(string3);
        }
        this.packageName = JInterface.getPackageFromClassName(string);
        this.imports = new Vector();
        this.interfaces = new Vector();
        this.jdc = new JDocComment();
        this.methods = new Vector();
        this.modifiers = new JModifiers();
        this.jdc.appendComment("Interface " + this.getLocalName() + ".");
        this.jdc.addDescriptor(JDocDescriptor.createVersionDesc(version));
    }

    public void addImport(String string) {
        if (string == null) {
            return;
        }
        if (string.length() == 0) {
            return;
        }
        String string2 = JInterface.getPackageFromClassName(string);
        if (string2 != null) {
            if (string2.equals(this.packageName)) {
                return;
            }
            if (string2.equals("java.lang")) {
                return;
            }
            int n = 0;
            while (n < this.imports.size()) {
                String string3 = (String)this.imports.elementAt(n);
                if (string3.equals(string)) {
                    return;
                }
                if (string3.compareTo(string) > 0) {
                    this.imports.insertElementAt(string, n);
                    return;
                }
                ++n;
            }
            this.imports.addElement(string);
        }
    }

    public void addInterface(String string) {
        if (!this.interfaces.contains(string)) {
            this.interfaces.addElement(string);
        }
    }

    public void addInterface(JInterface jInterface) {
        if (jInterface == null) {
            return;
        }
        String string = jInterface.getName();
        if (!this.interfaces.contains(string)) {
            this.interfaces.addElement(string);
        }
    }

    public void addMethod(JMethodSignature jMethodSignature) throws IllegalArgumentException {
        Object object;
        if (jMethodSignature == null) {
            String string = "The JMethodSignature cannot be null.";
            throw new IllegalArgumentException(string);
        }
        boolean bl = false;
        boolean bl2 = false;
        JModifiers jModifiers = jMethodSignature.getModifiers();
        int n = 0;
        while (n < this.methods.size()) {
            object = (JMethodSignature)this.methods.elementAt(n);
            if (((JMethodSignature)object).getModifiers().isProtected() && !jModifiers.isProtected()) {
                this.methods.insertElementAt(jMethodSignature, n);
                bl = true;
                break;
            }
            if (jMethodSignature.getName().compareTo(((JMethodSignature)object).getName()) < 0) {
                this.methods.insertElementAt(jMethodSignature, n);
                bl = true;
                break;
            }
            ++n;
        }
        if (!bl) {
            this.methods.addElement(jMethodSignature);
        }
        object = jMethodSignature.getParameterClassNames();
        int n2 = 0;
        while (n2 < ((Object)object).length) {
            this.addImport((String)object[n2]);
            ++n2;
        }
        JType jType = jMethodSignature.getReturnType();
        if (jType != null) {
            while (jType.isArray()) {
                jType = jType.getComponentType();
            }
            if (!jType.isPrimitive()) {
                this.addImport(jType.getName());
            }
        }
        JClass[] jClassArray = jMethodSignature.getExceptions();
        int n3 = 0;
        while (n3 < jClassArray.length) {
            this.addImport(jClassArray[n3].getName());
            ++n3;
        }
    }

    public String getFilename(String string) {
        File file;
        String string2 = this.getLocalName() + ".java";
        String string3 = "";
        if (this.packageName != null && this.packageName.length() > 0) {
            string3 = this.packageName.replace('.', File.separatorChar);
        }
        if (!(file = string == null ? new File(string3) : new File(string, string3)).exists()) {
            file.mkdirs();
        }
        if (file.toString().length() > 0) {
            string2 = file.toString() + File.separator + string2;
        }
        return string2;
    }

    public JDocComment getJDocComment() {
        return this.jdc;
    }

    public JMethodSignature[] getMethods() {
        Object[] objectArray = new JMethodSignature[this.methods.size()];
        this.methods.copyInto(objectArray);
        return objectArray;
    }

    public JMethodSignature getMethod(String string, int n) {
        int n2 = n;
        while (n2 < this.methods.size()) {
            JMethodSignature jMethodSignature = (JMethodSignature)this.methods.elementAt(n2);
            if (jMethodSignature.getName().equals(string)) {
                return jMethodSignature;
            }
            ++n2;
        }
        return null;
    }

    public JMethodSignature getMethod(int n) {
        return (JMethodSignature)this.methods.elementAt(n);
    }

    public JModifiers getModifiers() {
        return this.modifiers;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getName(boolean bl) {
        int n;
        String string = super.getName();
        if (bl && (n = string.lastIndexOf(".")) > 0) {
            string = string.substring(n + 1);
        }
        return string;
    }

    public boolean removeImport(String string) {
        boolean bl = false;
        if (string == null) {
            return bl;
        }
        if (string.length() == 0) {
            return bl;
        }
        bl = this.imports.removeElement(string);
        return bl;
    }

    public static boolean isValidClassName(String string) {
        if (string == null) {
            return false;
        }
        int n = string.lastIndexOf(".");
        if (n > 0) {
            string = string.substring(n + 1);
        }
        return JNaming.isValidJavaIdentifier(string);
    }

    public void print() {
        this.print(null, null);
    }

    public void print(String string, String string2) {
        int n;
        String string3 = this.getLocalName();
        String string4 = this.getFilename(string);
        File file = new File(string4);
        JSourceWriter jSourceWriter = null;
        try {
            jSourceWriter = new JSourceWriter(new FileWriter(file));
        }
        catch (IOException iOException) {
            System.out.println("unable to create class file: " + string4);
            return;
        }
        if (string2 == null) {
            string2 = System.getProperty("line.separator");
        }
        jSourceWriter.setLineSeparator(string2);
        StringBuffer stringBuffer = new StringBuffer();
        if (this.header != null) {
            this.header.print(jSourceWriter);
        } else {
            jSourceWriter.writeln("/*");
            jSourceWriter.writeln(" * $Id$");
            jSourceWriter.writeln("*/");
        }
        jSourceWriter.writeln();
        jSourceWriter.flush();
        if (this.packageName != null && this.packageName.length() > 0) {
            stringBuffer.setLength(0);
            stringBuffer.append("package ");
            stringBuffer.append(this.packageName);
            stringBuffer.append(';');
            jSourceWriter.writeln(stringBuffer.toString());
            jSourceWriter.writeln();
        }
        jSourceWriter.writeln("  //---------------------------------/");
        jSourceWriter.writeln(" //- Imported classes and packages -/");
        jSourceWriter.writeln("//---------------------------------/");
        jSourceWriter.writeln();
        int n2 = 0;
        while (n2 < this.imports.size()) {
            jSourceWriter.write("import ");
            jSourceWriter.write(this.imports.elementAt(n2));
            jSourceWriter.writeln(';');
            ++n2;
        }
        jSourceWriter.writeln();
        this.jdc.print(jSourceWriter);
        stringBuffer.setLength(0);
        if (this.modifiers.isPrivate()) {
            stringBuffer.append("private ");
        } else if (this.modifiers.isPublic()) {
            stringBuffer.append("public ");
        }
        if (this.modifiers.isAbstract()) {
            stringBuffer.append("abstract ");
        }
        stringBuffer.append("interface ");
        stringBuffer.append(this.getLocalName());
        stringBuffer.append(' ');
        if (this.interfaces.size() > 0) {
            n = 0;
            if (this.interfaces.size() > 1) {
                jSourceWriter.writeln(stringBuffer.toString());
                stringBuffer.setLength(0);
                n = 1;
            }
            stringBuffer.append("extends ");
            int n3 = 0;
            while (n3 < this.interfaces.size()) {
                if (n3 > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(this.interfaces.elementAt(n3));
                ++n3;
            }
            if (n != 0) {
                jSourceWriter.writeln(stringBuffer.toString());
                stringBuffer.setLength(0);
            } else {
                stringBuffer.append(' ');
            }
        }
        stringBuffer.append('{');
        jSourceWriter.writeln(stringBuffer.toString());
        stringBuffer.setLength(0);
        jSourceWriter.writeln();
        jSourceWriter.indent();
        if (this.methods.size() > 0) {
            jSourceWriter.writeln();
            jSourceWriter.writeln("  //-----------/");
            jSourceWriter.writeln(" //- Methods -/");
            jSourceWriter.writeln("//-----------/");
            jSourceWriter.writeln();
        }
        n = 0;
        while (n < this.methods.size()) {
            JMethodSignature jMethodSignature = (JMethodSignature)this.methods.elementAt(n);
            jMethodSignature.print(jSourceWriter);
            jSourceWriter.writeln(';');
            ++n;
        }
        jSourceWriter.unindent();
        jSourceWriter.writeln('}');
        jSourceWriter.flush();
        jSourceWriter.close();
    }

    public void setHeader(JComment jComment) {
        this.header = jComment;
    }

    public void setPackageName(String string) {
        this.packageName = string;
        this.changePackage(string);
    }

    private void printlnWithPrefix(String string, String string2, JSourceWriter jSourceWriter) {
        jSourceWriter.write(string);
        if (string2 == null) {
            return;
        }
        char[] cArray = string2.toCharArray();
        int n = 0;
        int n2 = 0;
        while (n2 < cArray.length) {
            char c = cArray[n2];
            if (c == '\n') {
                jSourceWriter.write(cArray, n, n2 - n + 1);
                n = n2 + 1;
                if (n2 < cArray.length) {
                    jSourceWriter.write(string);
                }
            }
            ++n2;
        }
        if (n < cArray.length) {
            jSourceWriter.write(cArray, n, cArray.length - n);
        }
        jSourceWriter.writeln();
    }

    private static String getPackageFromClassName(String string) {
        int n = -1;
        n = string.lastIndexOf(46);
        if (n > 0) {
            return string.substring(0, n);
        }
        return null;
    }
}

