/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.sitraka.bytecode;

import java.io.DataInputStream;
import java.io.IOException;
import org.apache.tools.ant.taskdefs.optional.depend.constantpool.ConstantPool;
import org.apache.tools.ant.taskdefs.optional.sitraka.bytecode.MethodInfo;

public class MethodInfoList {
    protected ConstantPool constantPool;
    protected MethodInfo[] methods;

    public MethodInfoList(ConstantPool pool) {
        this.constantPool = pool;
    }

    public void read(DataInputStream dis) throws IOException {
        int count = dis.readShort();
        this.methods = new MethodInfo[count];
        int i = 0;
        while (i < count) {
            this.methods[i] = new MethodInfo(this.constantPool);
            this.methods[i].read(dis);
            ++i;
        }
    }

    public int length() {
        return this.methods.length;
    }

    public MethodInfo getMethod(int i) {
        return this.methods[i];
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Methods: ").append(this.methods.length).append("\n");
        int i = 0;
        while (i < this.methods.length) {
            sb.append("\t");
            sb.append(this.getMethod(i).toString());
            sb.append("\n");
            ++i;
        }
        return sb.toString();
    }
}

