/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder.types;

import java.util.Enumeration;
import org.exolab.castor.builder.SourceGenerator;
import org.exolab.castor.builder.types.XSPatternBase;
import org.exolab.castor.builder.types.XSType;
import org.exolab.castor.xml.schema.Facet;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JSourceCode;
import org.exolab.javasource.JType;

public class XSInteger
extends XSPatternBase {
    Integer maxInclusive = null;
    Integer maxExclusive = null;
    Integer minInclusive = null;
    Integer minExclusive = null;
    private int _totalDigits = -1;
    private static JType jType = JType.Int;

    public XSInteger() {
        this(SourceGenerator.usePrimitiveWrapper());
    }

    public XSInteger(boolean bl) {
        super((short)32);
        jType = bl ? new JClass("java.lang.Integer") : JType.Int;
    }

    public JType getJType() {
        return jType;
    }

    public Integer getMaxExclusive() {
        return this.maxExclusive;
    }

    public Integer getMaxInclusive() {
        return this.maxInclusive;
    }

    public Integer getMinExclusive() {
        return this.minExclusive;
    }

    public Integer getMinInclusive() {
        return this.minInclusive;
    }

    public int getTotalDigits() {
        return this._totalDigits;
    }

    public boolean hasMaximum() {
        return this.maxInclusive != null || this.maxExclusive != null;
    }

    public boolean hasMinimum() {
        return this.minInclusive != null || this.minExclusive != null;
    }

    public void setMaxExclusive(int n) {
        this.maxExclusive = new Integer(n);
        this.maxInclusive = null;
    }

    public void setMaxExclusive(Integer n) {
        this.maxExclusive = n;
        this.maxInclusive = null;
    }

    public void setMaxInclusive(int n) {
        this.maxInclusive = new Integer(n);
        this.maxExclusive = null;
    }

    public void setMaxInclusive(Integer n) {
        this.maxInclusive = n;
        this.maxExclusive = null;
    }

    public void setMinExclusive(int n) {
        this.minExclusive = new Integer(n);
        this.minInclusive = null;
    }

    public void setMinExclusive(Integer n) {
        this.minExclusive = n;
        this.minInclusive = null;
    }

    public void setMinInclusive(int n) {
        this.minInclusive = new Integer(n);
        this.minExclusive = null;
    }

    public void setMinInclusive(Integer n) {
        this.minInclusive = n;
        this.minExclusive = null;
    }

    public void setTotalDigits(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException(this.getName() + ": the totalDigits facet must be positive");
        }
        this._totalDigits = n;
    }

    public void setFacets(SimpleType simpleType) {
        Enumeration enumeration = XSType.getFacets(simpleType);
        while (enumeration.hasMoreElements()) {
            Facet facet = (Facet)enumeration.nextElement();
            String string = facet.getName();
            if ("maxExclusive".equals(string)) {
                this.setMaxExclusive(facet.toInt());
                continue;
            }
            if ("maxInclusive".equals(string)) {
                this.setMaxInclusive(facet.toInt());
                continue;
            }
            if ("minExclusive".equals(string)) {
                this.setMinExclusive(facet.toInt());
                continue;
            }
            if ("minInclusive".equals(string)) {
                this.setMinInclusive(facet.toInt());
                continue;
            }
            if ("pattern".equals(string)) {
                this.setPattern(facet.getValue());
                continue;
            }
            if (!"totalDigits".equals(string)) continue;
            this.setTotalDigits(facet.toInt());
        }
    }

    public String createToJavaObjectCode(String string) {
        if (SourceGenerator.usePrimitiveWrapper()) {
            return super.createToJavaObjectCode(string);
        }
        StringBuffer stringBuffer = new StringBuffer("new Integer(");
        stringBuffer.append(string);
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public String createFromJavaObjectCode(String string) {
        StringBuffer stringBuffer = new StringBuffer("((Integer)");
        stringBuffer.append(string);
        stringBuffer.append(").intValue()");
        return stringBuffer.toString();
    }

    public void validationCode(JSourceCode jSourceCode, String string, String string2) {
        int n;
        Object object;
        if (jSourceCode == null) {
            jSourceCode = new JSourceCode();
        }
        jSourceCode.add("IntegerValidator typeValidator = new IntegerValidator();");
        if (this.hasMinimum()) {
            object = this.getMinExclusive();
            if (object != null) {
                jSourceCode.add("typeValidator.setMinExclusive(");
            } else {
                object = this.getMinInclusive();
                jSourceCode.add("typeValidator.setMinInclusive(");
            }
            jSourceCode.append(((Integer)object).toString());
            jSourceCode.append(");");
        }
        if (this.hasMaximum()) {
            object = this.getMaxExclusive();
            if (object != null) {
                jSourceCode.add("typeValidator.setMaxExclusive(");
            } else {
                object = this.getMaxInclusive();
                jSourceCode.add("typeValidator.setMaxInclusive(");
            }
            jSourceCode.append(((Integer)object).toString());
            jSourceCode.append(");");
        }
        if (string != null) {
            if (jType == JType.Int) {
                Integer.parseInt(string);
            }
            jSourceCode.add("typeValidator.setFixed(");
            jSourceCode.append(string);
            jSourceCode.append(");");
        }
        if ((object = this.getPattern()) != null) {
            jSourceCode.add("typeValidator.setPattern(\"");
            jSourceCode.append(XSType.escapePattern((String)object));
            jSourceCode.append("\");");
        }
        if ((n = this.getTotalDigits()) != -1) {
            jSourceCode.add("typeValidator.setTotalDigits(");
            jSourceCode.append(Integer.toString(n));
            jSourceCode.append(");");
        }
        jSourceCode.add(string2 + ".setValidator(typeValidator);");
    }
}

